definition module Random

//	**************************************************************************************************
//
//	General utility for random number generation.
//
//	This module has been written in Clean 1.3.1 and uses the Clean Standard Object I/O library 1.0.1
//	
//	**************************************************************************************************

from	StdPSt	import PSt, IOSt

::	RandomSeed

nullRandomSeed	:: RandomSeed
//	nullRandomSeed generates a useless RandomSeed (random nullRandomSeed = (0,nullRandomSeed)).

getNewRandomSeed:: !(PSt .l .p)	-> (!RandomSeed, !PSt .l .p)
//	GetNewRandomSeed generates a useful RandomSeed, using the current time.

random			:: !RandomSeed		-> (!Int, !RandomSeed)
//	Given a RandomSeed, Random generates a random number and a new RandomSeed.
